
<html>

<head>
    
     <?php   require_once("head.php");
     
     
         require_once("db.php") ;
     ?>


    <title>مرجع لوازم یدکی خودرو</title>


</head>

<body class="home-page">

<style>


.modern-shop-header {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: linear-gradient(135deg, #f8f9fa, #e9ecef);
  color: #2b2d42;
  padding: 12px 20px;
  border-radius: 8px;
  margin: 15px 0;
  box-shadow: 0 2px 8px rgba(0,0,0,0.05);
  border-right: 4px solid #1b66b3;
  font-size: 1.1rem;
  font-weight: 600;
}

.shop-view-all-btn {
  background: linear-gradient(to bottom, #1b66b3, #0c4785);
  color: white !important;
  text-align: center;
  font-size: 0.75rem;
  padding: 6px 12px;
  border-radius: 6px;
  text-decoration: none;
  transition: all 0.3s ease;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
  border: none;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  min-width: 120px;
  font-family:'SDF';
}

.shop-view-all-btn:hover {
  transform: translateY(-2px);
  box-shadow: 0 4px 8px rgba(0,0,0,0.15);
  background: linear-gradient(to bottom, #0c4785, #1b66b3);
}


@media (max-width: 768px) {
  .modern-shop-header {
    flex-direction: column;
    align-items: flex-start;
    gap: 10px;
    padding: 15px;
  }
  
  .shop-view-all-btn {
    align-self: flex-end;
    font-size: 0.7rem;
    padding: 5px 10px;
  }
}

@media (max-width: 480px) {
  .modern-shop-header {
    font-size: 1rem;
    padding: 10px 15px;
    font-family:'SDF';
  }
  
  .shop-view-all-btn {
    min-width: 100px;
    font-size: 0.65rem;
  }
}
</style>


 <header>
    <?php require_once("navbar.php"); ?>
 </header>


<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>جستجو زنده در پارتسمال</title>
  <style>
    /* پایه */
    html, body { height:100%; margin:0; padding:0; }
    body { font-family:'Tahoma',sans-serif; background:linear-gradient(135deg,#f0f4f8,#d9e2ec);direction:rtl; }
    .hero-search-section { text-align:center; padding:100px 20px 60px; }
    .site-title { font-size:42px; font-weight:bold; color:#1a202c; margin-bottom:40px; font-family:'SDF'; }
    .search-wrapper { display:flex; flex-wrap:wrap; justify-content:center; align-items:center;
      background:rgba(255,255,255,0.25); backdrop-filter:blur(10px); border-radius:40px; max-width:750px;
      margin:auto; padding:15px; gap:10px; box-shadow:0 10px 30px rgba(0,0,0,0.1); }
    select,input[type="text"],button { border-radius:30px; border:none; padding:14px 20px; font-size:12px; font-family: 'SDF'; }
    select,input[type="text"] { flex:1 1 auto; min-width:200px; background:#ffffffcc; }
    button { background:#2563eb; color:#fff; cursor:pointer; display:flex; align-items:center;
      justify-content:center; transition:background 0.3s; }
    button:hover { background:black; }


    /* انیمیشن‌ها */
    @keyframes overlayFadeIn { from { opacity:0; } to { opacity:1; } }
    @keyframes popupScaleIn { from { transform:translate(-50%,-50%) scale(0.8); opacity:0; }
                               to { transform:translate(-50%,-50%) scale(1); opacity:1; } }


    /* پاپ‌آپ */
    .popup { display:none; position:fixed; top:50%; left:50%; transform:translate(-50%,-50%) scale(0.8);
      background:#fff; padding:20px; width:90%; max-width:600px; border-radius:12px;
      box-shadow:0 20px 50px rgba(0,0,0,0.2); z-index:1000; max-height:80vh; overflow-y:auto; opacity:0; }
    .popup.show { display:block; animation:popupScaleIn 0.3s ease-out forwards; }

    .popup h2 { margin-top:0; font-size:20px; color:#1a202c; text-align:center; }
    .popup ul { list-style:none; padding:0; margin:10px 0; }
    .popup li { display:flex; align-items:center; gap:15px; padding:10px 0; border-bottom:1px solid #eee; }
    .popup li:last-child { border-bottom:none; }
    .popup img { width:60px; height:60px; border-radius:8px; object-fit:cover;border:2px solid black; }
    .popup a { text-decoration:none; color:#2563eb; display:flex; align-items:center; gap:10px; }
    .popup a h6 { margin:0; font-size:16px; color:#1a202c; }
    .popup a p { margin:0; font-size:14px; color:#555; }


  </style>
</head>
<body>
  <div class="hero-search-section">
    <h1 class="site-title">پارتسمال</h1>
    <div class="search-wrapper">
      <select id="search-category">
        <option value="shops">فروشگاه‌ها</option>
        <option value="repair">تعمیرگاه‌ها</option>
        <option value="parts">قطعات</option>
      </select>
      <input type="text" id="search-input" placeholder="جستجو کنید..." />
      <button id="search-btn" aria-label="جستجو">
        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="white" width="22" height="22">      <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-4.35-4.35m0 0A7.5 7.5 0 104.5 4.5a7.5 7.5 0 0012.15 12.15z"/></svg>
      </button>
      
<!-- فقط یک بار این بخش را داخل HTML بگذار -->
<div id="inline-guide" class="inline-guide hidden">
  🔍 <strong>راهنمای جستجو:</strong> لطفاً قطعه را به شکل <strong>"طبق هیوندای سانتافه 2018"</strong> 
</div>

<style>
  .inline-guide {
    text-align: center;
    margin-top: 15px;
    background: #fff7d6;
    color: #92400e;
    padding: 12px 18px;
    border-radius: 14px;
    font-size: 14px;
    font-weight: 500;
    max-width: 750px;
    margin-left: auto;
    margin-right: auto;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    border: 1px solid #facc15;
    transition: all 0.4s ease;
    opacity: 1;
  }

  .inline-guide.hidden {
    opacity: 0;
    transform: translateY(-10px);
    pointer-events: none;
    height: 0;
    overflow: hidden;
  }
</style>

<script>
  window.addEventListener('DOMContentLoaded', () => {
    const categoryEl = document.getElementById('search-category');
    const inlineGuide = document.getElementById('inline-guide');

    if (!categoryEl || !inlineGuide) return;

    categoryEl.addEventListener('change', () => {
      if (categoryEl.value === 'parts') {
        inlineGuide.classList.remove('hidden');
      } else {
        inlineGuide.classList.add('hidden');
      }
    });

    if (categoryEl.value === 'parts') {
      inlineGuide.classList.remove('hidden');
    }
  });
</script>

  
    </div>
  </div>


  <div class="overlay" id="popup-overlay"></div>
  <div class="popup" id="search-popup">
    <h2 id="popup-title">نتایج جستجو:</h2>
    <ul id="popup-results"></ul>
  </div>

<script>
  const categoryEl = document.getElementById('search-category');
  const inputEl = document.getElementById('search-input');
  const btnEl = document.getElementById('search-btn');
  const popup = document.getElementById('search-popup');
  const overlay = document.getElementById('popup-overlay');
  const listEl = document.getElementById('popup-results');
  const titleEl = document.getElementById('popup-title');

  const placeholders = {
    parts: 'مثلا: طبق هیوندای سانتافه سال 2018...',
    repair: 'مثلا:اتو مارول...',
    shops: 'مثلا:یدک شاپ...'
  };
  const titles = {
    shops: 'نتایج جستجو در فروشگاه‌ها:',
    repair: 'نتایج جستجو در تعمیرگاه‌ها:',
    parts: 'نتایج جستجو در قطعات:'
  };

  categoryEl.addEventListener('change', () => {
    inputEl.placeholder = placeholders[categoryEl.value] || '';
  });

  btnEl.addEventListener('click', (e) => {
    e.preventDefault();
    const q = inputEl.value.trim(); if (!q) return;
    const cat = categoryEl.value;
    fetch(`search.php?ajax=1&query=${encodeURIComponent(q)}&category=${cat}`)
      .then(res => {
        if (!res.ok) throw new Error('Network response was not ok');
        return res.json();
      })
      .then(data => {
        titleEl.textContent = titles[cat] || 'نتایج جستجو:';
        listEl.innerHTML = '';
        if (!Array.isArray(data) || data.length === 0) {
          listEl.innerHTML = '<li>نتیجه‌ای یافت نشد.</li>';
        } else {
          data.forEach(item => {
            const logo = item.logo || 'https://partsmall.ir/img/no_image_shop.jpg';
            const name = item.name || 'بدون عنوان';
            const link = item.link || '#';

            const li = document.createElement('li');
            li.innerHTML = `
              <a href="${link}" target="_blank">
                <img src="${logo}" alt="${name}" />
                <div>
                  <h6>${name}</h6>
                  <p>مشاهده جزئیات</p>
                </div>
              </a>`;
            listEl.appendChild(li);
          });
        }
        overlay.classList.add('show');
        popup.classList.add('show');

        // حذف پاپ‌آپ با کلیک خارج
        setTimeout(() => {
          document.addEventListener('click', function handler(event) {
            if (!popup.contains(event.target) && event.target !== btnEl) {
              popup.classList.remove('show');
              overlay.classList.remove('show');
              document.removeEventListener('click', handler);
            }
          });
        }, 100);
      })
      .catch(err => console.error('Fetch error:', err));
  });
</script>

</body>
</html>


         
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
    .home-page{
    background: linear-gradient(135deg, #f0f4f8, #d9e2ec);
}
        .floating-phone {
            position: fixed;
            bottom: 20px;
            left: 20px;
            z-index: 9999;
            transition: all 0.3s ease;
        }
        
        .phone-icon {
            width: 60px;
            height: 60px;
            background-color: #25D366;
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .phone-icon i {
            color: white;
            font-size: 24px;
        }
        
        .phone-icon:hover {
            transform: scale(1.1);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.2);
        }
        
        .phone-numbers {
            position: absolute;
            bottom: 70px;
            left: 0;
            background-color: white;
            border-radius: 12px;
            padding: 15px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            width: 200px;
            opacity: 0;
            visibility: hidden;
            transform: translateY(10px);
            transition: all 0.3s ease;
        }
        
        .phone-numbers.show {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }
        
        .phone-number {
            padding: 8px 0;
            border-bottom: 1px solid #eee;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .phone-number:last-child {
            border-bottom: none;
        }
        
        .phone-number i {
            margin-left: 10px;
            color: #25D366;
        }
        
        .phone-number a {
            color: #333;
            text-decoration: none;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            direction: ltr;
            display: inline-block;
        }
        
        .phone-number a:hover {
            color: #25D366;
        }
        
        @media (max-width: 768px) {
            .phone-icon {
                width: 50px;
                height: 50px;
            }
            
            .phone-numbers {
                width: 180px;
             justify-content: center;
            }
        }
        .phone-number a{
            padding-left:10px;
            font-family:'SDF';
             justify-content: center;
        }
    </style>
    
    <div class="floating-phone">
        <div class="phone-numbers" id="phoneNumbers">
            <div class="phone-number">
                <a href="tel:02133988737">021-33988737</a>
                <i class="fa-solid fa-phone"></i>
            </div>
            <div class="phone-number">
                <a href="tel:02133988747">021-33988747</a>
                <i class="fa-solid fa-phone"></i>
            </div>
        </div>
        <div class="phone-icon" id="phoneIcon">
            <i class="fa-solid fa-phone"></i>
        </div>
    </div>

    <script>
        const phoneIcon = document.getElementById('phoneIcon');
        const phoneNumbers = document.getElementById('phoneNumbers');
        
        phoneIcon.addEventListener('click', function() {
            phoneNumbers.classList.toggle('show');
        });
        

        document.addEventListener('click', function(event) {
            if (!phoneIcon.contains(event.target) && !phoneNumbers.contains(event.target)) {
                phoneNumbers.classList.remove('show');
            }
        });
    </script>
    


<link rel="stylesheet" href="css/swiper-bundle.min.css" />
<script src="js/swiper-bundle.min.js"></script>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>اسلایدر فروشگاه</title>
  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: Tahoma, sans-serif;
      background: #f9f9f9;
    }

    .slider-wrapper {
      width: 100%;
      overflow: hidden;
      position: relative;
      padding: 20px 0;
    }

    .shop-slider {
      display: flex;
      gap: 15px;
      overflow-x: auto;
      position: relative;
      cursor: grab;
    }

    /* Hide scrollbar */
    .shop-slider::-webkit-scrollbar {
      display: none;
    }

    .shop-slider {
      scrollbar-width: none;
      -ms-overflow-style: none;
    }

    .slide {
      flex: 0 0 auto;
      width: 160px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
      background: #fff;
      border-radius: 10px;
      transition: transform 0.3s ease;
    }

    .slide:hover {
      transform: translateY(-5px);
    }

    .shop-card {
      text-decoration: none;
      color: #333;
      display: block;
      padding: 15px;
      text-align: center;
      user-select: none;
      -webkit-user-drag: none;
      pointer-events: auto; /* لینک‌ها قابل کلیک باقی بمونن */
    }

    .shop-logo-frame {
      width: 80px;
      height: 80px;
      margin: 0 auto 10px;
      border-radius: 50%;
      overflow: hidden;
      border: 2px solid #eee;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .shop-logo {
      max-width: 100%;
      max-height: 100%;
      object-fit: contain;
      user-select: none;
      -webkit-user-drag: none;
    }

    .shop-title {
      font-size: 15px;
      margin: 0;
      line-height: 1.4;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      user-select: none;
    }

    @media (max-width: 768px) {
      .slide {
        width: 130px;
      }

      .shop-title {
        font-size: 14px;
      }
    }

    @media (max-width: 480px) {
      .slide {
        width: 110px;
      }

      .shop-title {
        font-size: 13px;
      }
    }

    .shop-slider.grabbing {
      cursor: grabbing;
    }
    .shop-modern-header {
  background: linear-gradient(135deg, #0072ff, #00c6ff);
  color: white;
  padding: 2rem 1rem;
  border-radius: 20px;
  margin: 2rem auto;
  max-width: 1500px;
  font-family: 'Vazirmatn', sans-serif;
  box-shadow: 0 8px 24px rgba(0,0,0,0.1);
  overflow: hidden;
}

.header-content {
  display: flex;
  flex-direction: column;
  align-items: center;
  text-align: center;
  gap: 1rem;
}

.header-icon {
  font-size: 2.5rem;
  background: rgba(255, 255, 255, 0.2);
  padding: 1rem;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
}

.header-text h1 {
  font-size: 2rem;
  font-weight: 900;
  margin: 0;
}

.header-text p {
  font-size: 1rem;
  font-weight: 400;
  opacity: 0.9;
  margin: 0;
}

.header-cta {
  margin-top: 1rem;
  display: inline-flex;
  align-items: center;
  gap: 0.5rem;
  color: white;
  font-weight: 600;
  text-decoration: none;
  background-color: rgba(255, 255, 255, 0.15);
  padding: 0.6rem 1rem;
  border-radius: 30px;
  transition: all 0.3s ease;
}

.header-cta:hover {
  background-color: rgba(255, 255, 255, 0.3);
  transform: translateY(-2px);
}

/* ریسپانسیو */
@media (min-width: 768px) {
  .header-content {
    flex-direction: row;
    justify-content: space-between;
    text-align: right;
  }

  .header-text {
    flex-grow: 1;
    text-align: right;
  }


}

  </style>
</head>
<body>
<!-- فونت فارسی و آیکون‌ها (اختیاری ولی پیشنهادشده) -->
<link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;600;900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
<div class="shop-modern-div">
<header class="shop-modern-header">
  <div class="header-content">
    <div class="header-icon">
      <i class="fas fa-store"></i>
    </div>
    <div class="header-text">
      <h1>فروشگاه‌</h1>

    </div>
    <div class="slider-wrapper">
<div class="shop-slider" id="draggableSlider">

<?php
if (isset($con)) {
  $sql = "SELECT id FROM shop WHERE logo IS NOT NULL AND TRIM(logo) <> ''";
  $result = mysqli_query($con, $sql);

  $shopIds = [];
  if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $shopIds[] = $row['id'];
    }

    shuffle($shopIds); // تصادفی‌سازی در PHP
    $selectedIds = array_slice($shopIds, 0, 15);
    $idList = implode(',', $selectedIds);

    // دریافت تمام اطلاعات فروشگاه‌ها
    $sql = "SELECT * FROM shop WHERE id IN ($idList)";
    $result = mysqli_query($con, $sql);

    $shops = [];
    while ($row = mysqli_fetch_assoc($result)) {
      $shops[$row['id']] = $row;
    }

    // مرتب‌سازی دستی مطابق با ترتیب تصادفی اولیه
    foreach ($selectedIds as $shopId) {
      if (!isset($shops[$shopId])) continue;

      $row = $shops[$shopId];
      $shopTitle = htmlspecialchars($row['name']);
      $shopLatin = strtolower($row['latin']);
      $shopImg = !empty($row['logo']) 
        ? "https://partsmall.ir/panel/assests/uploads/shop/logo/{$shopId}/{$row['logo']}"
        : "https://partsmall.ir/img/no_image_shop.jpg";
      ?>
      <div class="slide">
        <a href="/profile/<?php echo $shopId; ?>/<?php echo $shopLatin; ?>" class="shop-card">
          <div class="shop-logo-frame">
            <img src="<?php echo $shopImg; ?>" alt="<?php echo $shopTitle; ?>" class="shop-logo" loading="lazy">
          </div>
          <h4 class="shop-title"><?php echo $shopTitle; ?></h4>
        </a>
      </div>
      <?php
    }

  } else {
    echo '<p style="text-align:center; width:100%;">فروشگاهی با لوگو یافت نشد.</p>';
  }

} else {
  echo '<p style="text-align:center; width:100%;">خطا در اتصال به دیتابیس.</p>';
}
?>

</div>

</div>
    <a href="/shops" class="header-cta">
      مشاهده همه فروشگاه‌ها <i class="fas fa-arrow-left"></i>
    </a>
  </div>
</header>
</div>


<script>
  document.addEventListener('DOMContentLoaded', () => {
    const slider = document.getElementById('draggableSlider');

    let isDown = false;
    let startX;
    let scrollX;

    slider.addEventListener('mousedown', (e) => {
      isDown = true;
      slider.classList.add('grabbing');
      startX = e.pageX;
      scrollX = slider.scrollLeft;
    });

    slider.addEventListener('mouseup', () => {
      isDown = false;
      slider.classList.remove('grabbing');
    });

    slider.addEventListener('mouseleave', () => {
      isDown = false;
      slider.classList.remove('grabbing');
    });

    slider.addEventListener('mousemove', (e) => {
      if (!isDown) return;
      e.preventDefault();
      const x = e.pageX;
      const walk = (x - startX) * 2;
      slider.scrollLeft = scrollX - walk;
    });
  });
</script>

</body>
</html>

<style>

body {
    background-color: #f9f9f9;
    margin: 0;
    padding: 0;
}

.company-list {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
    padding: 20px;
    justify-content: center;
    align-items: center;
}

.company-item {
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    padding: 15px;
    width: calc(33.33% - 40px);
    text-align: center;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.company-item:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 12px rgba(0, 0, 0, 0.2);
}

.company-name {
    font-size: 18px;
    color: #333;
    margin-bottom: 10px;
}

.popup-btn {
    background-color: #007bff;
    color: #fff;
    border: none;
    padding: 10px 15px;
    border-radius: 8px;
    cursor: pointer;
    font-size: 14px;
    font-family:'system-ui';
    transition: background-color 0.3s ease;
}

.popup-btn:hover {
    background-color: #0056b3;
}


.popup-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.7);
    justify-content: center;
    align-items: center;
    z-index: 9999;
    backdrop-filter: blur(5px);
}

.popup-content {
    background-color: #fff;
    border-radius: 16px;
    padding: 20px;
    max-width: 600px;
    width: 90%;
    max-height: 80vh;
    overflow-y: auto;
    position: relative;
    animation: fadeIn 0.5s ease;
}

.close-btn {
    position: absolute;
    top: 10px;
    right: 15px;
    font-size: 24px;
    cursor: pointer;
    color: #aaa;
    transition: color 0.3s ease;
    z-index: 1000;
}

.close-btn:hover {
    color: #000;
}

.model-list {
    list-style-type: none;
    padding: 0;
    margin: 0;
}

.model-list h4 {
    font-size: 18px;
    color: black;
    background-color:#4dabf7;
    margin-top: 15px;
    border-radius:10px;
    padding: 10px;
    text-align: center;
}

.model-list ul {
    list-style-type: disc;
    margin-right: 20px;
    margin-top: 10px;
}

.model-list li {
    margin-top: 5px;
    font-size: 14px;
    color: #555;
}

.model-list a {
    color: #007bff;
    text-decoration: none;
    transition: color 0.3s ease;
}

.model-list a:hover {
    color: #0056b3;
}


@keyframes fadeIn {
    from {
        opacity: 0;
        transform: scale(0.9);
    }
    to {
        opacity: 1;
        transform: scale(1);
    }
}
.h2-in-pup-up{
    margin-top: 20px;
    font-size: 20px;
    font-weight: bolder;
    background-color: darkgrey;
    border-radius: 10px;
    padding-right: 30px;
    padding-left: 30px;
}
.div-car-name{
    display: flex;
    align-items: center;
    justify-content: center;
}
.modern-shop-slider-container{
    padding-top:60px;
}
</style>

<script>

function openPopup(companyId) {
    const popup = document.getElementById(`popup-${companyId}`);
    if (popup) {

        const allPopups = document.querySelectorAll('.popup-overlay');
        allPopups.forEach((p) => p.style.display = 'none');


        popup.style.display = 'flex';
    } else {
        console.error(`Element with id 'popup-${companyId}' not found.`);
    }
}


function closePopup(companyId) {
    const popup = document.getElementById(`popup-${companyId}`);
    if (popup) {
        popup.style.display = 'none';
    } else {
        console.error(`Element with id 'popup-${companyId}' not found.`);
    }
}


document.addEventListener('click', function (event) {
    const popups = document.querySelectorAll('.popup-overlay');
    popups.forEach((popup) => {
        if (!popup.contains(event.target) && !event.target.classList.contains('popup-btn')) {
            popup.style.display = 'none';
        }
    });
});
</script>
        
        

    
    
    
<div class="repair-modern-div">
<header class="repair-modern-header">
  <div class="header-content">
    <div class="header-icon">
      <i class="fas fa-tools"></i>
    </div>
    <div class="header-text">
      <h1>تعمیرگاه‌</h1>
      
    </div>
        <div class="slider-wrapper">
<div class="shop-slider" id="draggableSliderss">

<?php
if (isset($con)) {

  // مرحله 1: دریافت ID تعمیرگاه‌هایی که لوگو دارند
  $sql = "SELECT id FROM repair_shop WHERE logo IS NOT NULL AND TRIM(logo) <> ''";
  $result = mysqli_query($con, $sql);

  $repairIds = [];
  if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $repairIds[] = $row['id'];
    }

    // مرحله 2: شافل و انتخاب 15 آیتم تصادفی
    shuffle($repairIds);
    $selectedIds = array_slice($repairIds, 0, 15);
    $idList = implode(',', $selectedIds);

    // مرحله 3: گرفتن اطلاعات این تعمیرگاه‌ها
    $sql = "SELECT * FROM repair_shop WHERE id IN ($idList)";
    $result = mysqli_query($con, $sql);

    $repairs = [];
    while ($row = mysqli_fetch_assoc($result)) {
      $repairs[$row['id']] = $row;
    }

    // مرحله 4: نمایش به ترتیب تصادفی PHP
    foreach ($selectedIds as $repairId) {
      if (!isset($repairs[$repairId])) continue;

      $row = $repairs[$repairId];
      $repairTitle = htmlspecialchars($row['name']);
      $repairLatin = strtolower($row['latin']);
      $repairImg = !empty($row['logo']) 
        ? "https://partsmall.ir/panel/assests/uploads/repair/logo/{$repairId}/{$row['logo']}"
        : "https://partsmall.ir/img/no_image_repair.jpg";
      ?>
      <div class="slide">
        <a href="/carservice/<?php echo $repairId; ?>/<?php echo $repairLatin; ?>" class="shop-card">
          <div class="shop-logo-frame">
            <img src="<?php echo $repairImg; ?>" alt="<?php echo $repairTitle; ?>" class="shop-logo" loading="lazy">
          </div>
          <h4 class="shop-title"><?php echo $repairTitle; ?></h4>
        </a>
      </div>
      <?php
    }

  } else {
    echo '<p style="text-align:center; width:100%;">تعمیرگاهی با لوگو پیدا نشد.</p>';
  }

} else {
  echo '<p style="text-align:center; width:100%;">خطا در اتصال به دیتابیس.</p>';
}
?>

</div>

</div>
    <a href="/repair_shops" class="header-cta">
      مشاهده همه تعمیرگاه‌ها <i class="fas fa-arrow-left"></i>
    </a>
  </div>
</header>
</div>
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const slider = document.getElementById('draggableSliderss');

    let isDown = false;
    let startX;
    let scrollX;

    slider.addEventListener('mousedown', (e) => {
      isDown = true;
      slider.classList.add('grabbing');
      startX = e.pageX;
      scrollX = slider.scrollLeft;
    });

    slider.addEventListener('mouseup', () => {
      isDown = false;
      slider.classList.remove('grabbing');
    });

    slider.addEventListener('mouseleave', () => {
      isDown = false;
      slider.classList.remove('grabbing');
    });

    slider.addEventListener('mousemove', (e) => {
      if (!isDown) return;
      e.preventDefault();
      const x = e.pageX;
      const walk = (x - startX) * 2;
      slider.scrollLeft = scrollX - walk;
    });
  });
</script>


<div class="agency-modern-div">
<header class="agency-modern-header">
  <div class="agency-header-content">
    <div class="agency-header-icon">
      <i class="fas fa-building"></i>
    </div>
    <div class="agency-header-text">
      <h1>نمایندگی</h1>

    </div>
            <div class="slider-wrapper">
<div class="shop-slider" id="draggableSlidersss">

<?php
if (isset($con)) {

  // مرحله ۱: دریافت ID تمام نمایندگی‌ها
  $sql = "SELECT id FROM representation";
  $result = mysqli_query($con, $sql);

  $representationIds = [];
  if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
      $representationIds[] = $row['id'];
    }

    // مرحله ۲: تصادفی‌سازی و انتخاب ۱۵ مورد
    shuffle($representationIds);
    $selectedIds = array_slice($representationIds, 0, 15);
    $idList = implode(',', $selectedIds);

    // مرحله ۳: دریافت اطلاعات نمایندگی‌ها
    $sql = "SELECT * FROM representation WHERE id IN ($idList)";
    $result = mysqli_query($con, $sql);

    $representations = [];
    while ($row = mysqli_fetch_assoc($result)) {
      $representations[$row['id']] = $row;
    }

    // مرحله ۴: نمایش بر اساس ترتیب تصادفی
    foreach ($selectedIds as $representationId) {
      if (!isset($representations[$representationId])) continue;

      $row = $representations[$representationId];
      $representationTitle = htmlspecialchars($row['name']);
      $representationLatin = strtolower($row['latin']);
      $representationImg = !empty($row['logo']) 
        ? "https://partsmall.ir/panel/assests/uploads/representation/logo/{$representationId}/{$row['logo']}"
        : "https://partsmall.ir/img/no_image_representation.jpg";
      ?>
      <div class="slide">
        <a href="/representations/<?php echo $representationId; ?>/<?php echo $representationLatin; ?>" class="shop-card">
          <div class="shop-logo-frame">
            <img src="<?php echo $representationImg; ?>" alt="<?php echo $representationTitle; ?>" class="shop-logo" loading="lazy">
          </div>
          <h4 class="shop-title"><?php echo $representationTitle; ?></h4>
        </a>
      </div>
      <?php
    }

  } else {
    echo '<p style="text-align:center; width:100%;">نمایندگی‌ای یافت نشد.</p>';
  }

} else {
  echo '<p style="text-align:center; width:100%;">خطا در اتصال به دیتابیس.</p>';
}
?>

</div>

</div>
    <a href="/representations" class="agency-header-cta">
      مشاهده همه نمایندگی‌ها <i class="fas fa-arrow-left"></i>
    </a>
  </div>
</header>
</div>
<script>
  document.addEventListener('DOMContentLoaded', () => {
    const slider = document.getElementById('draggableSlidersss');

    let isDown = false;
    let startX;
    let scrollX;

    slider.addEventListener('mousedown', (e) => {
      isDown = true;
      slider.classList.add('grabbing');
      startX = e.pageX;
      scrollX = slider.scrollLeft;
    });

    slider.addEventListener('mouseup', () => {
      isDown = false;
      slider.classList.remove('grabbing');
    });

    slider.addEventListener('mouseleave', () => {
      isDown = false;
      slider.classList.remove('grabbing');
    });

    slider.addEventListener('mousemove', (e) => {
      if (!isDown) return;
      e.preventDefault();
      const x = e.pageX;
      const walk = (x - startX) * 2;
      slider.scrollLeft = scrollX - walk;
    });
  });
</script>

<style>

@media (max-width: 768px) {
.agency-modern-div{
    margin:15px;
}
.repair-modern-div{
    margin:15px;
}
.shop-modern-div{
    margin:15px;
}
}

.agency-modern-header {
  background: linear-gradient(135deg, #283e51, #485563);
  color: #fff;
  border-radius: 20px;
    margin: 2rem auto;
  max-width: 1500px;
  font-family: 'Vazirmatn', sans-serif;
  box-shadow: 0 8px 24px rgba(0,0,0,0.15);
  overflow: hidden;
  padding:2rem 1rem;
}

.agency-modern-header .agency-header-content {
  display: flex;
  flex-direction: column;
  align-items: center;
  text-align: center;
  gap: 1rem;
}

.agency-modern-header .agency-header-icon {
  font-size: 3rem;
  background: rgba(255, 255, 255, 0.1);
  padding: 1rem;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
}

.agency-modern-header .agency-header-text h1 {
  font-size: 2rem;
  font-weight: 900;
  margin: 0;
}

.agency-modern-header .agency-header-text p {
  font-size: 1rem;
  font-weight: 400;
  opacity: 0.95;
  margin: 0;
}

.agency-modern-header .agency-header-cta {
  margin-top: 1rem;
  display: inline-flex;
  align-items: center;
  gap: 0.5rem;
  color: white;
  font-weight: 600;
  text-decoration: none;
  background-color: rgba(255, 255, 255, 0.15);
  padding: 0.6rem 1rem;
  border-radius: 30px;
  transition: all 0.3s ease;
}

.agency-modern-header .agency-header-cta:hover {
  background-color: rgba(255, 255, 255, 0.3);
  transform: translateY(-2px);
}

/* ریسپانسیو */
@media (min-width: 768px) {
  .agency-modern-header .agency-header-content {
    flex-direction: row;
    justify-content: space-between;
    text-align: right;

  }

  .agency-modern-header .agency-header-text {
    flex-grow: 1;
    text-align: right;
  }

  .agency-modern-header .agency-header-icon {
    font-size: 3.5rem;
  }
}

.repair-modern-header {
  background: linear-gradient(135deg, #1f4037, #99f2c8);
  color: white;
  padding: 2rem 1rem;
  border-radius: 20px;
  margin: 2rem auto;
  max-width: 1500px;
  font-family: 'Vazirmatn', sans-serif;
  box-shadow: 0 8px 24px rgba(0,0,0,0.1);
  overflow: hidden;
}

.repair-modern-header .header-content {
  display: flex;
  flex-direction: column;
  align-items: center;
  text-align: center;
  gap: 1rem;
}

.repair-modern-header .header-icon {
  font-size: 3rem;
  background: rgba(255, 255, 255, 0.2);
  padding: 1rem;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
}

.repair-modern-header .header-text h1 {
  font-size: 2rem;
  font-weight: 900;
  margin: 0;
}

.repair-modern-header .header-text p {
  font-size: 1rem;
  font-weight: 400;
  opacity: 0.95;
  margin: 0;
}

.repair-modern-header .header-cta {
  margin-top: 1rem;
  display: inline-flex;
  align-items: center;
  gap: 0.5rem;
  color: white;
  font-weight: 600;
  text-decoration: none;
  background-color: rgba(255, 255, 255, 0.15);
  padding: 0.6rem 1rem;
  border-radius: 30px;
  transition: all 0.3s ease;
}

.repair-modern-header .header-cta:hover {
  background-color: rgba(255, 255, 255, 0.3);
  transform: translateY(-2px);
}

/* ریسپانسیو */
@media (min-width: 768px) {
  .repair-modern-header .header-content {
    flex-direction: row;
    justify-content: space-between;
    text-align: right;
  }

  .repair-modern-header .header-text {
    flex-grow: 1;
    text-align: right;
  }


}

.company-modal {
    overflow: hidden;
    max-height: none !important; /* جلوگیری از محدودیت ارتفاع */
}
</style>

  
    
    

    




<?php

?>

<div class="company-listing">
    <?php
    $sql20 = "SELECT * FROM company";
    $result20 = mysqli_query($con, $sql20);
    
    if (mysqli_num_rows($result20) > 0): ?>
        <div class="company-grid">
            <?php while ($row = mysqli_fetch_assoc($result20)):
                $bycompany = $row["name"];
                $bycompanyId = $row["id"];
                $bycompanyLatin = $row['latin'];
                
                // Skip incomplete records
                if (empty($bycompany) || empty($bycompanyLatin)) continue;
                ?>
                
                <article class="company-card">
                    <div class="company-card__content">
                        <h3 class="company-card__title"><?= htmlspecialchars($bycompany) ?></h3>
                        
                        <button class="company-card__button" 
                                data-popup-trigger="<?= $bycompanyId ?>"
                                aria-label="Show models for <?= htmlspecialchars($bycompany) ?>">
                            <span>نمایش مدل ها</span>
                            <svg class="icon" viewBox="0 0 24 24" aria-hidden="true">
                                <path d="M8.59 16.58L13.17 12 8.59 7.41 10 6l6 6-6 6-1.41-1.42z"/>
                            </svg>
                        </button>
                    </div>
                </article>
                
                <!-- Modal/Popup -->
                <dialog class="company-modal" id="modal-<?= $bycompanyId ?>">
                                            <header class="modal__header">
                            <h2 class="modal__title"><?= htmlspecialchars($bycompany) ?></h2>
                            <button class="modal__close" data-popup-close="<?= $bycompanyId ?>">
                                <svg class="icon" viewBox="0 0 24 24" aria-hidden="true" style="color:red;width:2.55rem;height: 2.25rem;">
                                    <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12 19 6.41z"/>
                                </svg>
                                </header>
                    <div class="modal__container" style="padding-bottom:100px;">

                            </button>
                        
                        
                        <div class="modal__content">
                            <?php
                            $sql21 = "SELECT * FROM car WHERE cat=" . $bycompanyId;
                            $result21 = mysqli_query($con, $sql21);
                            
                            if (mysqli_num_rows($result21) > 0): ?>
                                <div class="model-accordion">
                                    <?php while ($carRow = mysqli_fetch_assoc($result21)):
                                        $bycar = $carRow["name"];
                                        $bycarLatin = $carRow['latin'];
                                        $bycarCustom = $carRow['custom1'];
                                        ?>
                                        
                                        <details class="model-accordion__item">
                                            <summary class="model-accordion__header">
                                                <h3 class="model-accordion__title"><?= htmlspecialchars($bycar) ?></h3>
                                                <svg class="icon accordion-icon" viewBox="0 0 24 24" aria-hidden="true">
                                                    <path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"/>
                                                </svg>
                                            </summary>
                                            
                                            <div class="model-accordion__content">
                                                <?php
                                                $sql22 = "SELECT * FROM model";
                                                $result22 = mysqli_query($con, $sql22);
                                                
                                                if (mysqli_num_rows($result22) > 0): ?>
                                                    <ul class="model-list">
                                                        <?php while ($modelRow = mysqli_fetch_assoc($result22)):
                                                            $bymodel = $modelRow["name"];
                                                            $bymodelId = $modelRow["id"];
                                                            $bymodelDes = $modelRow["des"];
                                                            $bymodelLatin = $modelRow['latin'];
                                                            
                                                            if (strpos("," . $bycarCustom . ",", "," . $bymodelId . ",") === false) continue;
                                                            ?>
                                                            
                                                            <li class="model-list__item">
                                                                <a href="car/<?= $bycompanyLatin ?>/<?= $bycarLatin ?>/<?= $bymodelLatin ?>" 
                                                                   class="model-list__link">
                                                                    <span><?= htmlspecialchars($bymodelDes) ?></span>
                                                                    <svg class="icon" viewBox="0 0 24 24" aria-hidden="true">
                                                                        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"/>
                                                                    </svg>
                                                                </a>
                                                            </li>
                                                        <?php endwhile; ?>
                                                    </ul>
                                                <?php else: ?>
                                                    <p class="no-models">هیچ مدلی برای این کمپانی موجود نیست.</p>
                                                <?php endif; ?>
                                            </div>
                                        </details>
                                    <?php endwhile; ?>
                                </div>
                            <?php else: ?>
                                <div class="no-cars">
                                    <svg class="icon" viewBox="0 0 24 24" aria-hidden="true">
                                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/>
                                    </svg>
                                    <p>هیچ ماشینی برای این کمپانی موجود نیست</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </dialog>
            <?php endwhile; ?>
        </div>
    <?php else: ?>
        <div class="empty-state">
            <svg class="icon" viewBox="0 0 24 24" aria-hidden="true">
                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/>
            </svg>
            <p>No companies available.</p>
        </div>
    <?php endif; ?>
</div>

<style>

:root {
    --primary: #4361ee;
    --primary-light: #e0e7ff;
    --text: #1e293b;
    --text-light: #64748b;
    --bg: #ffffff;
    --border: #e2e8f0;
    --radius: 12px;
    --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}



/* فقط برای موبایل */
@media (max-width: 768px) {
  .company-listing {
    padding: 2rem 1rem;
    max-width: 100%;
  }
}
/* فقط در دستگاه‌های بزرگتر از موبایل (مثلاً تبلت به بالا) */
@media (min-width: 769px) {
  .company-listing {
    max-width: 1850px;
    margin: 0 auto;
    padding: 2rem 11rem;
  }
}
.company-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 1.5rem;
}

.company-card {
    background: var(--bg);
    border: 1px solid var(--border);
    border-radius: var(--radius);
    overflow: hidden;
    transition: var(--transition);
    box-shadow: var(--shadow);
}

.company-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
}

.company-card__content {
    padding: 1.5rem;
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.company-card__title {
    margin: 0;
    font-size: 1rem;
    font-weight: 600;
    text-align:center;
    font-family:'SDF';
}

.company-card__button {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    padding: 0.75rem 1.25rem;
    background: var(--primary-light);
    color: var(--primary);
    border: none;
    border-radius: var(--radius);
    font-weight: 500;
    cursor: pointer;
    font-family: 'SDF';
    transition: var(--transition);
}

.company-card__button:hover {
    background: var(--primary);
    color: white;
}


.company-modal {
    position: fixed;
    inset: 0;
    z-index: 100;
    background: rgba(0, 0, 0, 0);
    backdrop-filter: blur(4px);
    padding: 1rem;
    border: none;
    width: 100%;
    max-width: 100%;
    max-height: 100vh;
    overflow-y: auto;
}

.company-modal::backdrop {
    background: rgba(0, 0, 0, 0.5);
    backdrop-filter: blur(4px);
}

.modal__container {
    background: var(--bg);
    border-radius: var(--radius);
    max-width: 800px;
    margin: 0 auto;
    overflow: hidden;
    box-shadow: var(--shadow);
}

.modal__header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.5rem;
    border-bottom: 1px solid var(--border);
}

.modal__title {
    margin: 0;
    font-size: 1.5rem;
    color: white;
    font-weight:bold;
}

.modal__close {
    background: none;
    border: none;
    padding: 0.5rem;
    cursor: pointer;
    color: var(--text-light);
    transition: var(--transition);
}

.modal__close:hover {
    color: var(--text);
}

.modal__content {
    padding: 1.5rem;
}


.model-accordion {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.model-accordion__item {
    border: 1px solid var(--border);
    border-radius: var(--radius);
    overflow: hidden;
}

.model-accordion__header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem 1.5rem;
    background: var(--bg);
    cursor: pointer;
    list-style: none;
    font-family:'SDF';
}

.model-accordion__header::-webkit-details-marker {
    display: none;
}

.model-accordion__title {
    margin: 0;
    font-size: 1.125rem;
    color:black;
    
}

.model-accordion__content {
    padding: 0 1.5rem 1.5rem;
}


.model-list {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
    list-style: none;
    padding: 0;
    margin: 0;
}

.model-list__item {
    border-bottom: 1px solid var(--border);
}

.model-list__link {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    color: var(--text);
    text-decoration: none;
    transition: var(--transition);
}

.model-list__link:hover {
    color: var(--primary);
}


.empty-state, .no-cars, .no-models {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 1rem;
    padding: 2rem;
    text-align: center;
    color: var(--text-light);
}


.icon {
    width: 1.25rem;
    height: 1.25rem;
    fill: currentColor;
}

.accordion-icon {
    transition: var(--transition);
}

details[open] .accordion-icon {
    transform: rotate(180deg);
}

@media (max-width: 768px) {
    .company-grid {
        grid-template-columns: 1fr;
    }
    
    .modal__container {
        margin: 1rem;
    }
}
</style>

<script>

document.querySelectorAll('[data-popup-trigger]').forEach(button => {
    button.addEventListener('click', () => {
        const companyId = button.getAttribute('data-popup-trigger');
        const modal = document.getElementById(`modal-${companyId}`);
        modal.showModal();
    });
});

document.querySelectorAll('[data-popup-close]').forEach(button => {
    button.addEventListener('click', () => {
        const companyId = button.getAttribute('data-popup-close');
        const modal = document.getElementById(`modal-${companyId}`);
        modal.close();
    });
});


document.querySelectorAll('.company-modal').forEach(modal => {
    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.close();
        }
    });
});
</script>
        <div style="clear:both"></div>
    </ul>




    



















              <?php   require_once("footer.php") ?>



<script>
let scrollPosition = 0;

function disableBodyScroll() {

    scrollPosition = window.scrollY;
    document.body.style.overflow = 'hidden';
    document.body.style.touchAction = 'none';
    document.body.style.position = 'fixed';
    document.body.style.width = '100%';
    document.body.style.top = `-${scrollPosition}px`;
}

function enableBodyScroll() {
    document.body.style.overflow = '';
    document.body.style.touchAction = '';
    document.body.style.position = '';
    document.body.style.width = '';
    document.body.style.top = '';
    

    window.scrollTo(0, scrollPosition);
}


document.querySelectorAll('[data-popup-trigger]').forEach(button => {
    button.addEventListener('click', () => {
        const companyId = button.getAttribute('data-popup-trigger');
        const modal = document.getElementById(`modal-${companyId}`);
        modal.showModal();
        disableBodyScroll();
    });
});

document.querySelectorAll('[data-popup-close]').forEach(button => {
    button.addEventListener('click', () => {
        const companyId = button.getAttribute('data-popup-close');
        const modal = document.getElementById(`modal-${companyId}`);
        modal.close();
        enableBodyScroll();
    });
});


document.querySelectorAll('.company-modal').forEach(modal => {
    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.close();
            enableBodyScroll();
        }
    });
});


document.querySelectorAll('.modal__content').forEach(content => {
    content.addEventListener('scroll', (e) => {
        e.stopPropagation();
    });
});

</script>

<style>
 
.company-modal {
    overscroll-behavior: contain; 
}

.modal__container {
    max-height: 90vh;
    overflow-y: auto;
}

body.modal-open {
    overflow: hidden;
    position: fixed;
    width: 100%;
}
</style>


</body>

</html>
